unit SCMMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ExtCtrls, ComCtrls, Series, Chart,
  TRPCB, ORFn, ORNet, Mfunstr, uCore, rCore, uORPtf, vergencecontextorlib_tlb,
  Menus, Buttons, ConfirmVC;

type
  TfrmSCMMain = class(TForm)
    pcMain: TPageControl;
    tabSurg: TTabSheet;
    tabNotes: TTabSheet;
    pnl1: TORAutoPanel;
    pnl2: TORAutoPanel;
    pnlTop: TORAutoPanel;
    pnlBot: TORAutoPanel;
    pnlMid: TORAutoPanel;
    lblSpec: TLabel;
    memReq: TCaptionMemo;
    gbAction: TGroupBox;
    cbSpec: TORComboBox;
    lblPat: TLabel;
    lblPat1: TLabel;
    lblSSN: TLabel;
    lblSSN1: TLabel;
    lblDOB: TLabel;
    lblDOB1: TLabel;
    lblElig: TLabel;
    lblElig1: TLabel;
    btnPat: TButton;
    lbParse: TListBox;
    MainMenu1: TMainMenu;
    mmFile: TMenuItem;
    mmEdit: TMenuItem;
    mmHelp: TMenuItem;
    mmHelp1: TMenuItem;
    mmEdit1: TMenuItem;
    btnActAct: TButton;
    btnActWait: TButton;
    btnActReq: TButton;
    btnActSched: TButton;
    btnActComm: TButton;
    btnActCan: TBitBtn;
    ConfirmVC1: TConfirmVC;
    Image1: TImage;
    lblTitle: TLabel;
    pnlMenu: TPanel;
    sbWait: TStatusBar;
    lbSite: TORListBox;
    Clock: TTimer;
    pcNote: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    lblNote: TLabel;
    lblSched: TLabel;
    lbSched: TORListBox;
    cbRoom: TORComboBox;
    lblRoom: TLabel;
    lblName: TLabel;
    lstData: TORListBox;
    TabSheet6: TTabSheet;
    pnltab1: TPanel;
    cbNSurg: TORComboBox;
    lblNSurg: TLabel;
    btnPar: TButton;
    btnCan: TButton;
    btnWait: TButton;
    btnAction: TButton;
    btnSched: TButton;
    btnReq: TButton;
    Bevel1: TBevel;
    lbTemp: TORListBox;
    mmFile1: TMenuItem;
    btnComp: TButton;
    btnOut: TButton;
    lblLoc: TLabel;
    lblLoc1: TLabel;
    lblVet: TLabel;
    lblVet1: TLabel;
    lblSex1: TLabel;
    mmEdit2: TMenuItem;
    mmTools: TMenuItem;
    mmTools1: TMenuItem;
    mmTools2: TMenuItem;
    mmTools3: TMenuItem;
    pnlFlag: TPanel;
    mmReports: TMenuItem;
    mmReports1: TMenuItem;
    btnActDel: TButton;
    SyncTimer: TTimer;
    mmReports2: TMenuItem;
    mmTools4: TMenuItem;
    pnlProg: TPanel;
    ProgressBar1: TProgressBar;
    lblProg: TLabel;
    mmReports3: TMenuItem;
    btnActRem: TButton;
    lblNFA: TLabel;
    cbNFA: TORComboBox;
    cbNSA: TORComboBox;
    lblNSA: TLabel;
    lblNAtt: TLabel;
    cbNAtt: TORComboBox;
    cbAttCode: TORComboBox;
    lblAttCode: TLabel;
    TimeOut: TTimer;
    DisplayTimeOut: TTimer;
    mmTools5: TMenuItem;
    pnl: TPanel;
    lblReq: TLabel;
    hcNote: THeaderControl;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    lbNote: TORListBox;
    rgNote: TRadioGroup;
    pnlOEF: TPanel;
    Image2: TImage;
    btnExit: TButton;
    btnPrint: TButton;
    procedure FormCreate(Sender: TObject);
    procedure cbSpecChange(Sender: TObject);
    procedure lbNoteClick(Sender: TObject);
    procedure btnPatClick(Sender: TObject);
    procedure btnActSchedClick(Sender: TObject);
    procedure btnActWaitClick(Sender: TObject);
    procedure btnActReqClick(Sender: TObject);
    procedure EnableAction;
    procedure DisableAction;
    procedure btnWaitClick(Sender: TObject);
    procedure btnReqClick(Sender: TObject);
    procedure mmHelp1Click(Sender: TObject);
    procedure btnParClick(Sender: TObject);
    procedure mmEdit1Click(Sender: TObject);
    procedure btnActCanClick(Sender: TObject);
    procedure btnActionClick(Sender: TObject);
    procedure btnActActClick(Sender: TObject);
    procedure btnActCommClick(Sender: TObject);
    procedure btnSchedClick(Sender: TObject);
    procedure DisableHome;
    procedure EnableHome;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ClockTimer(Sender: TObject);
    procedure btnCanClick(Sender: TObject);
    procedure cbRoomClick(Sender: TObject);
    procedure lbSchedClick(Sender: TObject);
    procedure pcMainChange(Sender: TObject);
    procedure GetNoteList;
    procedure mmTools1Click(Sender: TObject);
    procedure mmFile1Click(Sender: TObject);
    procedure btnDirectClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure UpdateParam;
    procedure mmEdit2Click(Sender: TObject);
    procedure mmTools2Click(Sender: TObject);
    procedure mmTools3Click(Sender: TObject);
    procedure pnlFlagClick(Sender: TObject);
    procedure btnCompClick(Sender: TObject);
    procedure mmReports1Click(Sender: TObject);
    procedure ScheduleKey;
    procedure btnCalClick(Sender: TObject);
    procedure btnOutClick(Sender: TObject);
    procedure btnActDelClick(Sender: TObject);
    procedure RefreshNoteList;
    procedure lbNoteMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RefreshSpecList;
    procedure rgNoteClick(Sender: TObject);
    procedure SyncTimerTimer(Sender: TObject);
    procedure mmReports2Click(Sender: TObject);
    procedure mmTools4Click(Sender: TObject);
    procedure mmReports3Click(Sender: TObject);
    procedure btnProcessClick(Sender: TObject);
    procedure btnActRemClick(Sender: TObject);
    procedure hcNoteSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure btnPrintClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure CheckIssue;
    procedure TimeOutTimer(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DisplayTimeOutTimer(Sender: TObject);
    procedure ResetDisplayTimerCounter;
    procedure pnl1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mmTools5Click(Sender: TObject);
    procedure pnlOEFClick(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure ReadOnly;
  private
    { Private declarations }
  public
    { Public declarations }
    frmSCMMain: TfrmSCMMain;
  end;

var
  frmSCMMain: TfrmSCMMain;
  UserID, NIFN, SpecIFN, SSIFN, OpIFN, UsePTLD, Tool, SyncDone, UserSpec, ConMatch, PCPConsult: integer;
  UserName, UserMan, UserSched, UserPos, sync: string;
  DFN, PtName, SpecName, SpecAbbr, ReqAction: string;
  SpecFac, SpecCare, UserStart, UserStop: string;
  sort, datesort, lastsect, Issue, DisplayTimerMin, DisplayTimerCnt, UserSite, ptsort, PutFlag, UserFac, SiteIFN: integer;
  Room, Range, Title: string;
  Today: double;
  SpecColor: TColor;
  FlagList: TStringList;
  HasFlag: boolean;

implementation

{$R *.dfm}

uses fPatInq, rLocal, fGenPrint, fRptBox, fSched, fWait, fAddComm,
     fCurrentWait, fRequest, fCurrentReq, fAbout, fParam, fSiteParam,
     fCSched, fCancel, fSelPt, fService, fPatientFlagMulti, fDSched,
     fComplete, fWaitReport, fMAG, fCkWait, fOther, fUsage, ORSystem,
     fCurrentOut, fTimeOut, fDelay, fFindPt, fFindCon;

procedure TfrmSCMMain.FormCreate(Sender: TObject);
var
  data, appver, currver: string;
  J: integer;
begin
  if not ConnectToServer('APTWL') then
    begin
      Close;
      Exit;
    end;
  // WindowState := wsMaximized;     // full screen
  currver   := sCallV('APTWL GET CURR VER', []);
  appver    := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  appver    := copy(appver, 1, length(appver)-1); // get rid of some kind of control character!
  if (appver <> currver) then
    begin
      MessageDlg('The most recent version is ' + currver + CRLF + 'You are using version ' + appver +
        CRLF + 'Please get version ' + currver + ' from the appropriate folder.', mterror, [mbOK], 0);
      Close;
      Exit;
    end;
  CallV('APTWL GET SITE', []);
  lbSite.Items := RPCBrokerV.Results;
  UsePTLD := StrToInt(piece(lbSite.Items[2], '^', 1));
  DisplayTimerMin  := StrToInt(piece(lbSite.Items[3], '^', 1));
  TimeOut.Interval := StrToInt(piece(lbSite.Items[3], '^', 2));
  ConMatch := StrToInt(piece(lbSite.Items[4], '^', 1));
  SiteIFN  := StrToInt(piece(lbSite.Items[5], '^', 1));
  sync      := sCallV('APTWL XREF', [0, SiteIFN]);  // initiate synchronization
  data      := sCallV('APTWL USERINFO', [SiteIFN]);
  UserID    := StrToInt(piece(data, '^', 1));
  UserName  := piece(data, '^', 2);
  UserMan   := piece(data, '^', 3);  // scm manager
  UserFac   := StrToInt(piece(data, '^', 4));  // 1=facilitator, 2=care coordinator, 3=or coordinator , 4=surgeon, 5=read-only
  UserSched := piece(data, '^', 5);  // can schedule ops
  UserSpec  := StrToInt(piece(data, '^', 6));  // user specialty if one only
  UserStart := DateToStr(Date) + ' ' + TimeToStr(Time);
  if UserMan = 'YES' then UserPos := 'Manager'
    else
      begin
        if UserFac = 1 then UserPos := 'Facilitator';
        if UserFac = 2 then UserPos := 'Care Coordinator';
        if UserFac = 3 then UserPos := 'OR Coordinator';
        if UserFac = 4 then UserPos := 'Surgeon';
        if UserFac = 5 then UserPos := 'Read-Only User';
        if UserSched = 'YES' then UserPos := 'Scheduler';
      end;
  UserSite := StrToInt(piece(lbSite.Items[0], '^', 1)); // domain file ifn
  sbWait.Panels[0].Text := MixedCase(UserName);
  sbWait.Panels[1].Text := MixedCase(piece(lbSite.Items[1], '^', 2));
  sbWait.Panels[2].Text := MixedCase(UserPos);
  sbWait.Panels[5].Text := IntToStr(DisplayTimerMin);
  Today := StrToFloat(sCallV('APTWL GET TODAY', []));
  RefreshSpecList;
  DisableHome;
  DisableAction;
  ReqAction    := '0';
  Tool         := 0;
  PutFlag      := 0;
  lblTitle.Caption := '';
  // for testing
  if (UserSite = 648) and (UserID = 165) then
    begin
      UserSite        := 653;
      UsePTLD         := 1;
      lbSite.Items[0] := '653^Roseburg VAMC';
    end;
  if UserFac = 5 then ReadOnly;
  Show;
  Caption := Caption + ' - ' + piece(lbSite.Items[0], '^', 2);
  pcMain.ActivePage  := tabSurg;
  ClockTimer(Self);
  SyncDone := 0;
  DisplayTimerCnt   := 0;
  if UserSpec > 0 then
    begin
      for J := 0 to cbSpec.Items.Count -1 do
        begin
          if piece(cbSpec.Items[J], '^', 1) = IntToStr(UserSpec) then
            begin
              cbSpec.ItemIndex := J;
              cbSpecChange(Self);
              break;
            end;
        end;
    end;
  if sync = '1' then
    begin
      SyncTimer.Enabled := True;
      pnlProg.Visible   := True;
    end
  else if cbSpec.ItemIndex <> -1 then btnReq.Enabled := True;
  cbSpec.SetFocus;
end;

procedure TfrmSCMMain.cbSpecChange(Sender: TObject);
var
  data: string;
begin
  if length(cbspec.Text) > 1 then
    begin
      data      := cbSpec.Items[cbSpec.ItemIndex];
      SpecIFN   := StrToInt(piece(data, '^', 1));
      SpecName  := piece(data, '^', 2);
      SpecAbbr  := piece(data, '^', 4);
      SSIFN     := 0;  // default
      if piece(data, '^', 5) <> '' then SSIFN := StrToInt(piece(data, '^', 5));
      if (SSIFN = 0) then
        begin
          if MessageDlg('The ' + SpecName + ' specialty has no Service/Section definition.' + CRLF +
            'Please take care of that before using this specialty.', mtwarning, [mbOK, mbCancel], 0) = mrOK then
            begin
              GetService(cbSpec.Items);
              if frmService.btnExit.ModalResult = mrCancel then Exit;
            end
          else Exit;
        end;
      Range      := 'T-7';
      sort       := 2;
      datesort   := 1;
      ptsort     := 1;
      lastsect   := 2;
      pnl3.Color := clBtnFace;
      pnl4.Color := clBtnFace;
      pnl5.Color := clBlue;
      Title      := 'Select ' + SpecName + ' Note Request';
      RefreshNoteList;
      SpecColor         := clWindowText;  // default
      if piece(data, '^', 7) <> '' then SpecColor := StringToColor(piece(data, '^', 7));
      if SpecColor = clWindowText then MessageDlg(SpecName + ' has no specialty color defined', mtinformation, [mbOK], 0);
      lblTitle.Font.Color := SpecColor;
      lblTitle.Caption  := SpecName;
      EnableHome;
      pnl2.Visible      := False;
      memReq.Clear;
    end;
end;

procedure TfrmSCMMain.lbNoteClick(Sender: TObject);
var
  Result: string;
begin
  if lbNote.ItemIndex < 0 then Exit;
  NIFN := lbNote.ItemIEN;
  DFN  := piece(lbNote.Items[lbNote.ItemIndex], '^', 2);
  Patient := TPatient.Create;
  Patient.DFN  := DFN;
  PtName := piece(lbNote.Items[lbNote.ItemIndex], '^', 3);
  PCPConsult := 0;
  if ConMatch = 1 then
    begin
      FindConsult(SpecIFN);
      PCPConsult := StrToInt(frmFindCon.lbFSelect.Items[0]);
    end;
  Result := sCallV('APTWL GET DEMOG', [Patient.DFN]);
  EnableAction;
  lblPat1.Caption  := piece(Result, '^', 1);
  lblSSN1.Caption  := piece(Result, '^', 2);
  lblDOB1.Caption  := piece(Result, '^', 3);
  lblSex1.Caption  := piece(Result, '^', 5) + ', ' + piece(Result, '^', 6);
  lblVet1.Caption  := piece(Result, '^', 7);
  lblElig1.Caption := piece(Result, '^', 4);
  lblLoc1.Caption  := piece(Result, '^', 8);
  if piece(Result, '^', 9) <> '' then lblLoc1.Caption := lblLoc1.Caption + ', ' + piece(Result, '^', 9);
  pnlOEF.Visible := False;
  if piece(Result, '^', 10) <> '' then pnlOEF.Visible := True;
  HasFlag := False;
  FlagList := TStringList.Create;
  pnlFlag.Visible  := False;
  HasActiveFlg(FlagList, HasFlag, Patient.DFN);
  if HasFlag then pnlFlag.Visible := True;
  memReq.Clear;
  CallV('APTWL GET TEXT', [NIFN]);
  memReq.Lines := RPCBrokerV.Results;
  if sCallV('APTWL IS COSIGNED', [NIFN]) = '0' then
    begin
      MessageDlg('This Request Note has not been cosigned.', mtwarning, [mbOK], 0);
    end;
  CallV('APTWL PARSE TEXT', [NIFN, Patient.DFN, SpecIFN]);
  lbParse.Items := RPCBrokerV.Results;
end;

procedure TfrmSCMMain.btnPatClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmSCMMain.btnActSchedClick(Sender: TObject);
begin
  CheckIssue;
  if Issue = 1 then Exit;
  if UserSched <> 'YES' then
    begin
      ScheduleKey;
      Exit;
    end;
  if MessageDlg('We need to enter Request data first before Scheduling.', mtConfirmation,
    [mbOK, mbCancel], 0) = mrCancel then Exit;
  Request(lbParse.Items, 1);
  if piece(ReqAction, '^', 1) = '0' then
    ShowMessage('Request data has not been entered.');
    Exit;
  lbParse.Items[32] := piece(ReqAction, '^', 2); // case #
  Schedule(SpecIFN, lbParse.Items, 1);
  // refresh note request list
  if PutFlag = 1 then RefreshNoteList;
end;

procedure TfrmSCMMain.btnActWaitClick(Sender: TObject);
begin
  CheckIssue;
  if Issue = 1 then Exit;
  if MessageDlg('This action assumes that the patient' + CRLF + 'is surgically cleared.',
    mtconfirmation, [mbOK, mbCancel], 0) = mrCancel then Exit;
  Wait(lbParse.Items, 1, 'W');
  if PutFlag = 1 then RefreshNoteList;
end;

procedure TfrmSCMMain.btnActReqClick(Sender: TObject);
begin
  CheckIssue;
  if Issue = 1 then Exit;
  lbTemp.Clear;
  CallV('APTWL GET WL FOR ONE PT', [SpecIFN, PatientDFN]);
  lbTemp.Items := RPCBrokerV.Results;
  if lbTemp.Items.Count > 0 then CheckWait(lbTemp.Items, lbTemp.Items.Count);
  Request(lbParse.Items, 1);
  if PutFlag = 1 then RefreshNoteList;
end;

procedure TfrmSCMMain.EnableAction;
begin
  gbAction.Enabled    := True;
  btnActAct.Enabled   := True;
  btnActWait.Enabled  := True;
  btnActReq.Enabled   := True;
  btnActSched.Enabled := True;
  btnActComm.Enabled  := True;
  btnActCan.Enabled   := True;
  btnActDel.Enabled   := True;
  btnActRem.Enabled   := True;
  btnPat.Enabled      := True;
  pnl2.Visible        := True;
end;

procedure TfrmSCMMain.btnWaitClick(Sender: TObject);
begin
  CurrentWait('W');
end;

procedure TfrmSCMMain.btnReqClick(Sender: TObject);
begin
  CurrentRequest;
end;

procedure TfrmSCMMain.mmHelp1Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmSCMMain.btnParClick(Sender: TObject);
begin
  EditParam(SpecIFN);
  UpdateParam;
end;

procedure TfrmSCMMain.mmEdit1Click(Sender: TObject);
begin
  if UserMan <> 'YES' then
    begin
      MessageDlg('You need Manager-level access to use this option.', mtwarning, [mbOK], 0);
      Exit;
    end;
  SiteParam;
  RefreshSpecList;
end;

procedure TfrmSCMMain.btnActCanClick(Sender: TObject);
begin
  DisableAction;
  memReq.Clear;
  GetNoteList;
end;

procedure TfrmSCMMain.DisableAction;
begin
  gbAction.Enabled    := False;
  btnActAct.Enabled   := False;
  btnActWait.Enabled  := False;
  btnActReq.Enabled   := False;
  btnActSched.Enabled := False;
  btnActComm.Enabled  := False;
  btnActCan.Enabled   := False;
  btnActDel.Enabled   := False;
  btnPat.Enabled      := False;
  btnActRem.Enabled   := False;
  lblPat1.Caption  := '';
  lblSSN1.Caption  := '';
  lblDOB1.Caption  := '';
  lblElig1.Caption := '';
  pnl2.Visible     := False;
end;

procedure TfrmSCMMain.btnActionClick(Sender: TObject);
begin
  CurrentWait('A');
end;

procedure TfrmSCMMain.btnActActClick(Sender: TObject);
begin
  Wait(lbParse.Items, 1, 'A');
  if PutFlag = 1 then RefreshNoteList;
end;

procedure TfrmSCMMain.btnActCommClick(Sender: TObject);
var
  Success: string;
begin
  if MessageDlg('Are you sure you want to Outsource this case?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
  AddComm('Outsourcing Activity Comment');
  Success := sCallV('APTWL PUT NR TO CO', [lbParse.Items, SpecIFN, frmAddComm.memComm.Lines]);
  if piece(Success, '^', 1) = '1' then
    begin
      MessageDlg('The Note Request for ' + PtName + ' has been moved to the Outsourced list' +
        CRLF + 'and had an entry, ' + SpecAbbr + ' ' + piece(Success, '^', 2) + ', created in the SCM.', mtinformation, [mbOK], 0);
      RefreshNoteList;
    end;
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg('The Note Request could not be moved to the Outsourced List.' + CRLF +
        piece(Success, '^', 2), mtinformation, [mbOK], 0);
    end;
end;

procedure TfrmSCMMain.btnSchedClick(Sender: TObject);
begin
  CurrentSchedule;
end;

procedure TfrmSCMMain.DisableHome;
begin
  btnAction.Enabled := False;
  btnWait.Enabled   := False;
  btnReq.Enabled    := False;
  btnSched.Enabled  := False;
  btnPar.Enabled    := False;
  btnCan.Enabled    := False;
  btnPat.Enabled    := False;
  btnOut.Enabled    := False;
  btnComp.Enabled   := False;
  rgNote.Enabled    := False;
  lblReq.Enabled    := False;
  lbNote.Enabled    := False;
end;

procedure tfrmSCMMain.EnableHome;
begin
  btnAction.Enabled := True;
  btnWait.Enabled   := True;
  if (SyncDone = 1) or (sync = '0') then btnReq.Enabled := True;
  btnSched.Enabled  := True;
  btnPar.Enabled    := True;
  btnCan.Enabled    := True;
  btnPat.Enabled    := True;
  btnOut.Enabled    := True;
  btnComp.Enabled   := True;
  rgNote.Enabled    := True;
  lblReq.Enabled    := True;
  lbNote.Enabled    := True;
end;

procedure TfrmSCMMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
  if Key = 116 then
    begin
      ConfirmVC1.RPCBroker := RPCBrokerV;
      ConfirmVC1.LockedApplication := True;
      Application.Minimize;
    end;
end;

procedure TfrmSCMMain.ClockTimer(Sender: TObject);
begin
  sbWait.Panels[4].Text := '  ' + DateToStr(Date) + '  ' + TimeToStr(Time);
end;

procedure TfrmSCMMain.btnCanClick(Sender: TObject);
begin
  Cancelled;
end;

procedure TfrmSCMMain.cbRoomClick(Sender: TObject);
begin
  Room := piece(cbRoom.Items[cbRoom.ItemIndex], '^', 2);
  lblSched.Caption := 'Todays Schedule for ' + Room;
  CallV('APTWL GET SCHED BY ROOM', [cbRoom.ItemIEN]);
  lbSched.Items    := RPCBrokerV.Results;
  lblSched.Enabled := True;
  lbSched.Enabled  := True;
end;

procedure TfrmSCMMain.lbSchedClick(Sender: TObject);
begin
  OpIFN := lbSched.ItemIEN;
  CallV('APTWL GET REQ DATA', [OpIFN]);
  lstData.Items   := RPCBrokerV.Results;
  lblName.Caption := piece(lstData.Items[0], '^', 2) + '  -  ' + piece(lstData.Items[8], '^', 3);
  lblNote.Enabled := True;
  pcNote.Enabled  := True;
end;

procedure TfrmSCMMain.pcMainChange(Sender: TObject);
begin
  if pcMain.ActivePage = tabNotes then
    begin
      CallV('APTWL GET ROOMS', []);
      cbRoom.Items      := RPCBrokerV.Results;
      pcNote.Enabled    := False;
      pcNote.ActivePage := TabSheet1;
      lblSched.Enabled  := False;
      lbSched.Enabled   := False;
      lblName.Caption   := '';
      lblNote.Enabled   := False;
    end;
end;

procedure TfrmSCMMain.GetNoteList;
begin
  RefreshNoteList;
end;


procedure TfrmSCMMain.mmTools1Click(Sender: TObject);
begin
  if UserFac = 5 then Exit;
  SpecIFN   := 0;
  SpecName  := '';
  SPecAbbr  := '';
  SSIFN     := 0;
  SpecColor := clWindowText;
  DirectEntry;
  cbSpecChange(Self);
end;

procedure TfrmSCMMain.mmFile1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmSCMMain.btnDirectClick(Sender: TObject);
begin
  DirectEntry;
end;

procedure TfrmSCMMain.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Success: string;
begin
  UserStop := DateToStr(Date) + ' ' + TimeToStr(Time);
  Success := sCallV('APTWL PUT USER STATS', [UserStart, UserStop]);
  Application.Terminate;
end;

procedure TfrmSCMMain.UpdateParam;
begin
  if (fParam.Change = 1) then
    begin
      lblTitle.Font.Color := SpecColor;
      lblTitle.Caption    := SpecName;
      RefreshSpecList;
      if (fParam.TitleChange = 1) then
        begin
          CallV('APTWL GET REQ',[SpecIFN, 'T-7']);
          lbNote.Items := RPCBrokerV.Results;
        end;
    end;
end;

procedure TfrmSCMMain.mmEdit2Click(Sender: TObject);
begin
  if UserFac = 5 then Exit;
  if UserSched <> 'YES' then  // doesn't have SROSCH key
    begin
      ScheduleKey;
      Exit;
    end;
  Schedule(0, lbTemp.Items, 3);
  cbSpecChange(Self);
end;

procedure TfrmSCMMain.mmTools2Click(Sender: TObject);
begin
  if UserFac = 5 then Exit;
  if UserSched <> 'YES' then   // doesn't have SROSCH key
    begin
      ScheduleKey;
      Exit;
    end;
  Tool := 2;
  DisplaySchedule;
end;

procedure TfrmSCMMain.mmTools3Click(Sender: TObject);
begin
  Tool := 3;
  DisplaySchedule;
end;

procedure TfrmSCMMain.pnlFlagClick(Sender: TObject);
begin
  ShowFlags;
end;

procedure TfrmSCMMain.btnCompClick(Sender: TObject);
begin
  DisplayComplete;
end;

procedure TfrmSCMMain.mmReports1Click(Sender: TObject);
begin
  WaitTimes;
end;

procedure TfrmSCMMain.ScheduleKey;
begin
  ShowMessage('You need the SROSCH key to use this option.');
end;

procedure TfrmSCMMain.btnCalClick(Sender: TObject);
begin
  Calendar;
end;

procedure TfrmSCMMain.btnOutClick(Sender: TObject);
begin
  CurrentOut;
end;

procedure TfrmSCMMain.btnActDelClick(Sender: TObject);
begin
  if piece(lbNote.Items[lbNote.ItemIndex], '^', 6) = 'D' then
    begin
      if MessageDlg('This request already has patient requested delay data.' + CRLF +
        'Do you wish to add another set?  Or remove this request from delay status?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
    end;
  PatientDelay('NR', NIFN, piece(lbNote.Items[lbNote.ItemIndex], '^', 6));
  GetNoteList;
end;

procedure TfrmSCMMain.RefreshNoteList;
var
  Count: integer;
begin
  lbNote.Clear;
  CallV('APTWL GET REQ',[SpecIFN, Range, sort, datesort, ptsort]);
  lbNote.Items := RPCBrokerV.Results;
  Count := lbNote.Items.Count;
  if piece(lbNote.Items[0], '^', 3) = '*' then Count := 0;
  lblReq.Caption := Title + '  (' + IntToStr(Count) + ')';
  if Range = 'Today' then rgNote.ItemIndex := 0;
  if Range = 'T-7'   then rgNote.ItemIndex := 1;
  if Range = 'T-30'  then rgNote.ItemIndex := 2;
  if Range = 'T-120' then rgNote.ItemIndex := 3;
  if Range = 'All'   then rgNote.ItemIndex := 4;
  DisableAction;
end;

procedure TfrmSCMMain.lbNoteMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ResetTimeOut;
  if piece(lbNote.Items[0], '^', 3) = '*' then Exit;
  if Button = mbLeft then
    begin
      lbNoteClick(Self);
      Exit;
    end;
  if piece(lbNote.Items[lbNote.ItemIndex], '^', 6) = '' then Exit;  // not prd
  CallV('APTWL GET PRD', [SpecIFN, lbNote.ItemIEN, 'NR']);  // note ifn, dfn
  ReportBox(RPCBrokerV.Results, 'Patient Requested Delay Data', True);
end;

procedure TfrmSCMMain.RefreshSpecList;
begin
  CallV('APTWL GET SPEC',[1, UserID, SiteIFN]);
  cbSpec.Items := RPCBrokerV.Results;
end;

procedure TfrmSCMMain.rgNoteClick(Sender: TObject);
begin
  Range := rgNote.Items[rgNote.ItemIndex];
  RefreshNoteList;
end;

procedure TfrmSCMMain.SyncTimerTimer(Sender: TObject);
var
  Ready: string;
begin
  Ready := sCallV('APTWL XREF READY', [SiteIFN]);
  if Ready = '0' then
    begin
      SyncDone := 1;
      if (btnAction.Enabled = True) then btnReq.Enabled := True;
      SyncTimer.Enabled := False;
      pnlProg.Visible := False;
      Exit;
    end;
  if (Ready = '1') and (pnlProg.Visible = True) then ProgressBar1.StepIt;
end;

procedure TfrmSCMMain.mmReports2Click(Sender: TObject);
begin
  UsageStats;
end;

procedure TfrmSCMMain.mmTools4Click(Sender: TObject);
var
  sync: string;
begin
  if UserFac = 5 then Exit;
  if SyncDone = 0 then   // already running
    begin
      MessageDlg('Synchronization is already running!', mtwarning, [mbOK], 0);
      Exit;
    end;
  sync := sCallV('APTWL XREF', [1, SiteIFN]);  // initiate synchronization
  if sync = '0' then
    begin
      MessageDlg('Synchronization is already running!', mtwarning, [mbOK], 0);
      Exit;
    end;
  pnlProg.Visible   := True;
  SyncTimer.Enabled := True;
end;

procedure TfrmSCMMain.mmReports3Click(Sender: TObject);
begin
  Calendar;
end;

procedure TfrmSCMMain.btnProcessClick(Sender: TObject);
begin
  lbNoteClick(Self);
end;

procedure TfrmSCMMain.btnActRemClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to remove the note for ' + piece(lbNote.Items[lbNote.ItemIndex], '^', 3) + '?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
  CallV('APTWL REMOVE NOTE', [SpecIFN, lbNote.ItemIEN]);
  GetNoteList;
end;

procedure TfrmSCMMain.hcNoteSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if piece(lbNote.Items[0], '^',1) = '*' then Exit;
  if lbNote.Items.Count = 1 then Exit;
  lbNote.Clear;
  for i := 0 to hcNote.Sections.Count -1 do
    begin
      if (Section = hcNote.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for sort by date
  if Sort = 2 then
    begin
      if datesort = 1 then datesort := 0
      else datesort := 1;
    end;
  // get direction for sort by patient
  if Sort = 0 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  RefreshNoteList;
end;

procedure TfrmSCMMain.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmSCMMain.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl3.Color := barcolor;
  if Sect = 1 then pnl4.Color := barcolor;
  if Sect = 2 then pnl5.Color := barcolor;
end;

procedure TfrmSCMMain.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbTemp.Items.Clear;
  for J := 0 to hcNote.Sections.Count-1 do lbTemp.Items.Add(hcNote.Sections[J].Text);
  Title := 'Note Request List for ' + SpecName;
  GenPrint(lbNote, Title, lbNote.Pieces, lbNote.TabPositions, lbTemp);
end;

procedure TfrmSCMMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSCMMain.CheckIssue;
begin
  Issue := 0;
  if (lbParse.Items[34] <> '') or (lbParse.Items[38] <> '') then
    begin
      if MessageDlg('This request has Med Issues or Surg Tasks and' + CRLF +
        'should be placed on the Action Required List.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then Issue := 1;
    end;
end;

procedure TfrmSCMMain.TimeOutTimer(Sender: TObject);
begin
  ApplicationTimeOut;
end;

procedure TfrmSCMMain.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ResetTimeOut;
end;

procedure TfrmSCMMain.DisplayTimeOutTimer(Sender: TObject);
begin
  DisplayTimerCnt := DisplayTimerCnt + 1;
  sbWait.Panels[5].Text := IntToStr(DisplayTimerMin - DisplayTimerCnt);
end;

procedure TfrmSCMMain.ResetDisplayTimerCounter;
begin
  DisplayTimerCnt := 0;
  DisplayTimeOut.Enabled := False;
  DisplayTimeOut.Enabled := True;
  sbWait.Panels[5].Text := IntToStr(DisplayTimerMin - DisplayTimerCnt);
end;

procedure TfrmSCMMain.pnl1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  //
end;

procedure TfrmSCMMain.mmTools5Click(Sender: TObject);
begin
  FindPatient;
end;

procedure TfrmSCMMain.pnlOEFClick(Sender: TObject);
begin
  CallV('APTWL GET OEF DATA', [DFN]);
  ReportBox(RPCBrokerV.Results, 'OEF/OIF Data for ' + PtName, False);
end;

procedure TfrmSCMMain.Image2Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmSCMMain.Image1Click(Sender: TObject);
begin
  ShowAbout;
end;

procedure TfrmSCMMain.ReadOnly;
begin
  btnPar.Enabled      := False;
  btnActAct.Enabled   := False;
  btnActWait.Enabled  := False;
  btnActReq.Enabled   := False;
  btnActComm.Enabled  := False;
  btnActSched.Enabled := False;
  btnActRem.Enabled   := False;
  btnActDel.Enabled   := False;
end;

end.
